/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SourcesListPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYSRLT";
    private static final String TRACE_MASKF = "XNTYSRLF";
    private static final String TRACE_MASKD = "XNTYSRLD";
    private transient ItemDescriptor[] m_idSourcesListTable;
    private transient ColumnDescriptor[] m_cdSourcesListTableStructure;
    private int[] m_iSourcesListTableSelection;
    private Map data;
    public static final String SOURCES_LIST_TABLE = "SourcesListTable";
    public static final String TASKLET_SELECTED_SOURCE = "TaskletSelectedSource";

    public void setSourcesListTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        }
        this.m_iSourcesListTableSelection = selected;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "SourcesListPanel");
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setDisposed();
        } else if (command.equals(this.getMountPrefix() + "AddButton")) {
            request.setData("CommandName", "AddButton");
        } else if (command.equals(this.getMountPrefix() + "EditButton")) {
            if (this.m_iSourcesListTableSelection == null || this.m_iSourcesListTableSelection.length == 0) {
                request = null;
            } else {
                request.setData("CommandName", "EditButton");
                Map sourceMap = (Map)this.data.get(SOURCES_LIST_TABLE);
                Iterator iterator = sourceMap.keySet().iterator();
                for (int z = 0; z < this.m_iSourcesListTableSelection[0]; ++z) {
                    iterator.next();
                }
                String mySource = (String)iterator.next();
                request.setData(TASKLET_SELECTED_SOURCE, mySource);
            }
        } else if (command.equals(this.getMountPrefix() + "DeleteButton")) {
            if (this.m_iSourcesListTableSelection == null || this.m_iSourcesListTableSelection.length == 0) {
                request = null;
            } else {
                request.setData("CommandName", "DeleteButton");
                Map sourceMap = (Map)this.data.get(SOURCES_LIST_TABLE);
                Iterator iterator = sourceMap.keySet().iterator();
                for (int z = 0; z < this.m_iSourcesListTableSelection[0]; ++z) {
                    iterator.next();
                }
                String mySource = (String)iterator.next();
                request.setData(TASKLET_SELECTED_SOURCE, mySource);
            }
        }
        if (request != null) {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "<> update()");
        if (newData instanceof Map) {
            Map map = (Map)newData;
            String command = (String)map.get("CommandName");
            Map sourceMap = (Map)this.data.get(SOURCES_LIST_TABLE);
            if (command.equals("DeleteButton")) {
                Iterator iterator = sourceMap.keySet().iterator();
                for (int z = 0; z <= this.m_iSourcesListTableSelection[0]; ++z) {
                    iterator.next();
                }
                iterator.remove();
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + SOURCES_LIST_TABLE, new int[0]);
                this.m_iSourcesListTableSelection = new int[0];
            } else if (command.equals("AddButton")) {
                Map src = (Map)map.get("AddButton");
                HashMap myMap = new HashMap();
                myMap.put("DataMapSourceName", src.get("DataMapSourceName"));
                myMap.put("DataMapFilterName", src.get("DataMapFilterName"));
                myMap.put("DataMapDescription", src.get("DataMapDescription"));
                myMap.put("DataMapObjectName", src.get("DataMapObjectName"));
                myMap.put("DataMapEnabledCheckbox", src.get("DataMapEnabledCheckbox"));
                sourceMap.put((String)src.get("DataMapSourceName"), myMap);
            } else if (command.equals("EditButton")) {
                Iterator iterator = sourceMap.keySet().iterator();
                for (int z = 0; z < this.m_iSourcesListTableSelection[0]; ++z) {
                    iterator.next();
                }
                String sourceName = (String)iterator.next();
                Map myMap = (Map)sourceMap.get(sourceName);
                Map src = (Map)map.get("EditButton");
                myMap.put("DataMapSourceName", src.get("DataMapSourceName"));
                myMap.put("DataMapFilterName", src.get("DataMapFilterName"));
                myMap.put("DataMapDescription", src.get("DataMapDescription"));
                myMap.put("DataMapObjectName", src.get("DataMapObjectName"));
                myMap.put("DataMapEnabledCheckbox", src.get("DataMapEnabledCheckbox"));
            }
            this.userTaskManager.refreshAllElements();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        if (this.data == null) {
            this.data = new TreeMap();
        }
        if (this.data.get(SOURCES_LIST_TABLE) == null) {
            this.data.put(SOURCES_LIST_TABLE, new HashMap());
        }
        this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
        this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_idSourcesListTable = new ItemDescriptor[0];
        this.m_cdSourcesListTableStructure = new ColumnDescriptor[0];
        this.m_iSourcesListTableSelection = new int[0];
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getSourcesListTableRowCount() {
        Map sourceMap = (Map)this.data.get(SOURCES_LIST_TABLE);
        return sourceMap.size();
    }

    public ItemDescriptor[] getSourcesListTableRowAt(int index) {
        Map sourceMap = (Map)this.data.get(SOURCES_LIST_TABLE);
        Iterator iterator = sourceMap.keySet().iterator();
        for (int z = 0; z < index; ++z) {
            iterator.next();
        }
        String sourceName = (String)iterator.next();
        Map source = (Map)sourceMap.get(sourceName);
        ItemDescriptor[] id = new ItemDescriptor[5];
        id[0] = new ItemDescriptor(this.getMountPrefix() + "Name" + index, (String)source.get("DataMapSourceName"));
        String[] filters = (String[])source.get("DataMapFilterName");
        String filterString = "";
        if (filters != null) {
            for (int i = 0; i < filters.length - 1; ++i) {
                filterString = filterString + filters[i] + ", ";
            }
            if (filters.length > 0) {
                filterString = filterString + filters[filters.length - 1];
            }
        }
        id[1] = new ItemDescriptor(this.getMountPrefix() + "Filter" + index, filterString);
        id[2] = new ItemDescriptor(this.getMountPrefix() + "Desc" + index, (String)source.get("DataMapDescription"));
        id[3] = source.get("DataMapObjectName") != null ? new ItemDescriptor(this.getMountPrefix() + "Objects" + index, ((LocalizableText)source.get("DataMapObjectName")).toString()) : new ItemDescriptor(this.getMountPrefix() + "Objects" + index, "");
        id[4] = new ItemDescriptor(this.getMountPrefix() + "Status" + index, ((Boolean)source.get("DataMapEnabledCheckbox")).toString());
        return id;
    }

    public ColumnDescriptor[] getSourcesListTableRowStructure() {
        return this.m_cdSourcesListTableStructure;
    }

    public int getSourcesListTableRowStatus() {
        return 3;
    }

    public void setSourcesListTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idSourcesListTable = items;
    }

    public int[] getSourcesListTableSelection() {
        return this.m_iSourcesListTableSelection;
    }
}

